<?php
session_start();
require_once '../config/db.php';

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../src/login.php');
    exit;
}

// جلب المشاريع لاختيار المشروع
$projects = $pdo->query('SELECT id, name FROM projects ORDER BY id DESC')->fetchAll();

// إضافة نموذج وحدة جديد
if (isset($_POST['add_unit'])) {
    $project_id = intval($_POST['project_id']);
    $name = trim($_POST['name']);
    $area = floatval($_POST['area']);
    $price = floatval($_POST['price']);
    $bedrooms = intval($_POST['bedrooms']);
    $bathrooms = intval($_POST['bathrooms']);
    $features = trim($_POST['features']);
    $stmt = $pdo->prepare('INSERT INTO unit_models (project_id, name, area, price, bedrooms, bathrooms, features) VALUES (?, ?, ?, ?, ?, ?, ?)');
    $stmt->execute([$project_id, $name, $area, $price, $bedrooms, $bathrooms, $features]);
}

// حذف نموذج وحدة
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare('DELETE FROM unit_models WHERE id = ?');
    $stmt->execute([$id]);
}

// تعديل نموذج وحدة
if (isset($_POST['edit_unit'])) {
    $id = intval($_POST['id']);
    $project_id = intval($_POST['project_id']);
    $name = trim($_POST['name']);
    $area = floatval($_POST['area']);
    $price = floatval($_POST['price']);
    $bedrooms = intval($_POST['bedrooms']);
    $bathrooms = intval($_POST['bathrooms']);
    $features = trim($_POST['features']);
    $stmt = $pdo->prepare('UPDATE unit_models SET project_id=?, name=?, area=?, price=?, bedrooms=?, bathrooms=?, features=? WHERE id=?');
    $stmt->execute([$project_id, $name, $area, $price, $bedrooms, $bathrooms, $features, $id]);
}

// جلب جميع نماذج الوحدات
$units = $pdo->query('SELECT u.*, p.name as project_name FROM unit_models u LEFT JOIN projects p ON u.project_id = p.id ORDER BY u.id DESC')->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة نماذج الوحدات</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .container { max-width: 1100px; margin: 40px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 24px; text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 32px; }
        th, td { padding: 10px; border-bottom: 1px solid #EEEEEE; text-align: center; }
        th { background: #EA9218; color: #fff; }
        .btn { padding: 6px 16px; border-radius: 4px; border: none; cursor: pointer; }
        .btn-edit { background: #3A4750; color: #fff; }
        .btn-delete { background: #d00; color: #fff; }
        .form-inline input, .form-inline select, .form-inline textarea { margin: 0 8px 8px 0; padding: 6px; }
        .form-inline { display: flex; flex-wrap: wrap; align-items: center; gap: 8px; margin-bottom: 24px; }
        textarea { resize: vertical; }
    </style>
</head>
<body>
    <div class="container">
        <h2>إدارة نماذج الوحدات</h2>
        <!-- نموذج إضافة نموذج وحدة جديد -->
        <form class="form-inline" method="post">
            <select name="project_id" required>
                <option value="">اختر المشروع</option>
                <?php foreach ($projects as $project): ?>
                    <option value="<?= $project['id'] ?>"> <?= htmlspecialchars($project['name']) ?> </option>
                <?php endforeach; ?>
            </select>
            <input type="text" name="name" placeholder="اسم النموذج" required>
            <input type="number" name="area" placeholder="المساحة (م²)" step="0.01" required>
            <input type="number" name="price" placeholder="السعر" step="0.01" required>
            <input type="number" name="bedrooms" placeholder="عدد غرف النوم" required>
            <input type="number" name="bathrooms" placeholder="عدد دورات المياه" required>
            <textarea name="features" placeholder="المميزات" rows="2"></textarea>
            <button class="btn" type="submit" name="add_unit">إضافة نموذج</button>
        </form>
        <!-- جدول نماذج الوحدات -->
        <table>
            <tr>
                <th>الرقم</th>
                <th>اسم المشروع</th>
                <th>اسم النموذج</th>
                <th>المساحة</th>
                <th>السعر</th>
                <th>غرف النوم</th>
                <th>دورات المياه</th>
                <th>المميزات</th>
                <th>تعديل</th>
                <th>حذف</th>
            </tr>
            <?php foreach ($units as $unit): ?>
            <tr>
                <form method="post">
                    <td><?= $unit['id'] ?></td>
                    <td>
                        <select name="project_id" required>
                            <?php foreach ($projects as $project): ?>
                                <option value="<?= $project['id'] ?>" <?= $unit['project_id']==$project['id']?'selected':'' ?>><?= htmlspecialchars($project['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                    <td><input type="text" name="name" value="<?= htmlspecialchars($unit['name']) ?>" required></td>
                    <td><input type="number" name="area" value="<?= $unit['area'] ?>" step="0.01" required></td>
                    <td><input type="number" name="price" value="<?= $unit['price'] ?>" step="0.01" required></td>
                    <td><input type="number" name="bedrooms" value="<?= $unit['bedrooms'] ?>" required></td>
                    <td><input type="number" name="bathrooms" value="<?= $unit['bathrooms'] ?>" required></td>
                    <td><textarea name="features" rows="2"><?= htmlspecialchars($unit['features']) ?></textarea></td>
                    <td>
                        <input type="hidden" name="id" value="<?= $unit['id'] ?>">
                        <button class="btn btn-edit" type="submit" name="edit_unit">تعديل</button>
                    </td>
                    <td>
                        <a class="btn btn-delete" href="?delete=<?= $unit['id'] ?>" onclick="return confirm('هل أنت متأكد من حذف النموذج؟');">حذف</a>
                    </td>
                </form>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
